# Generated by Django 5.1.5 on 2025-02-28 10:06

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='CustomUser',
            fields=[
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('sacco_user_id', models.CharField(max_length=100, primary_key=True, serialize=False)),
                ('title', models.CharField(blank=True, max_length=255, null=True)),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('email', models.EmailField(blank=True, max_length=254, null=True)),
                ('phone', models.CharField(blank=True, max_length=255, null=True, unique=True)),
                ('id_number', models.CharField(blank=True, max_length=255, null=True)),
                ('id_type', models.CharField(blank=True, max_length=255, null=True)),
                ('date_of_birth', models.CharField(blank=True, max_length=255, null=True)),
                ('notes', models.CharField(blank=True, max_length=255, null=True)),
                ('secondary_phone_number', models.CharField(blank=True, max_length=255, null=True)),
                ('postal_address', models.CharField(blank=True, max_length=255, null=True)),
                ('physical_address', models.CharField(blank=True, max_length=255, null=True)),
                ('marital_status', models.CharField(blank=True, max_length=255, null=True)),
                ('marital_status_other', models.CharField(blank=True, max_length=255, null=True)),
                ('gender', models.CharField(blank=True, max_length=255, null=True)),
                ('gender_other', models.CharField(blank=True, max_length=255, null=True)),
                ('historical_member_id', models.CharField(blank=True, max_length=255, null=True)),
                ('profession', models.CharField(blank=True, max_length=255, null=True)),
                ('employment_status', models.CharField(blank=True, max_length=255, null=True)),
                ('terms_of_service', models.CharField(blank=True, max_length=255, null=True)),
                ('currently_working', models.CharField(blank=True, max_length=255, null=True)),
                ('joining_fee', models.CharField(blank=True, max_length=255, null=True)),
                ('joining_fee_reference', models.CharField(blank=True, max_length=255, null=True)),
                ('share_capital_contribution', models.CharField(blank=True, max_length=255, null=True)),
                ('share_capital_reference', models.CharField(blank=True, max_length=255, null=True)),
                ('jiinue_account_contribution', models.CharField(blank=True, max_length=255, null=True)),
                ('jiinue_account_reference', models.CharField(blank=True, max_length=255, null=True)),
                ('diaspora_account_contribution', models.CharField(blank=True, max_length=255, null=True)),
                ('diaspora_account_reference', models.CharField(blank=True, max_length=255, null=True)),
                ('boresha_biashara_account_contribution', models.CharField(blank=True, max_length=255, null=True)),
                ('boresha_biashara_account_reference', models.CharField(blank=True, max_length=255, null=True)),
                ('employer', models.CharField(blank=True, max_length=255, null=True)),
                ('employer_phone_number', models.CharField(blank=True, max_length=255, null=True)),
                ('business', models.CharField(blank=True, max_length=255, null=True)),
                ('staff_id', models.CharField(blank=True, max_length=255, null=True)),
                ('kra_pin', models.CharField(blank=True, max_length=255, null=True)),
                ('subscribed_to_mbanking', models.CharField(blank=True, max_length=255, null=True)),
                ('mobile_loan_disallowed', models.CharField(blank=True, max_length=255, null=True)),
                ('referral', models.CharField(blank=True, max_length=100, null=True)),
                ('verify_status', models.BooleanField(default=False)),
                ('otp_digit', models.CharField(blank=True, max_length=10, null=True)),
                ('profile_picture', models.ImageField(blank=True, null=True, upload_to='profile_pictures/')),
                ('signature', models.ImageField(blank=True, null=True, upload_to='signatures/')),
                ('registration_number', models.CharField(blank=True, max_length=255, null=True)),
                ('registration_date', models.CharField(blank=True, max_length=255, null=True)),
                ('business_location', models.CharField(blank=True, max_length=255, null=True)),
                ('business_county', models.CharField(blank=True, max_length=255, null=True)),
                ('company_type', models.CharField(blank=True, max_length=255, null=True)),
                ('member_type', models.CharField(blank=True, max_length=255, null=True)),
                ('member_ID', models.CharField(blank=True, max_length=255, null=True)),
                ('business_description', models.CharField(blank=True, max_length=255, null=True)),
                ('monthly_net_cashflow', models.CharField(blank=True, max_length=255, null=True)),
                ('account_type', models.CharField(blank=True, max_length=255, null=True)),
                ('services', models.CharField(blank=True, max_length=255, null=True)),
                ('role', models.CharField(choices=[('SuperAdmin', 'SuperAdmin'), ('Admin', 'Admin'), ('User', 'User')], default='User', max_length=255)),
                ('signing_mandate', models.CharField(blank=True, max_length=255, null=True)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('chama_number_of_members', models.IntegerField(blank=True, null=True)),
                ('chama_name', models.CharField(blank=True, max_length=255, null=True)),
                ('postal_code', models.CharField(blank=True, max_length=255, null=True)),
                ('chama_town', models.CharField(blank=True, max_length=255, null=True)),
                ('chama_telephone_office', models.CharField(blank=True, max_length=255, null=True)),
                ('chama_nature_of_business', models.CharField(blank=True, max_length=255, null=True)),
                ('chama_building', models.CharField(blank=True, max_length=255, null=True)),
                ('chama_date_of_incorporation', models.CharField(blank=True, max_length=255, null=True)),
                ('chama_certificate_of_incorporation_number', models.CharField(blank=True, max_length=255, null=True)),
                ('chama_associate_company', models.CharField(blank=True, max_length=255, null=True)),
                ('chama_account_type', models.CharField(blank=True, max_length=255, null=True)),
                ('chama_other_bank_accounts', models.JSONField(blank=True, max_length=255, null=True)),
                ('chama_signing_mandate', models.CharField(blank=True, max_length=255, null=True)),
                ('chama_signature', models.CharField(blank=True, max_length=255, null=True)),
                ('fosa_account', models.TextField(blank=True, null=True)),
                ('is_staff', models.BooleanField(default=False)),
                ('is_superuser', models.BooleanField(default=False)),
                ('is_active', models.BooleanField(default=True)),
                ('kwara_active', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContactMessage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', models.EmailField(max_length=254)),
                ('subject', models.CharField(max_length=255)),
                ('message', models.TextField()),
                ('sent_at', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='DepositRequest',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('member_sacco_id', models.CharField(max_length=255)),
                ('amount', models.IntegerField()),
                ('request_time', models.DateTimeField(auto_now_add=True)),
                ('payment_method', models.CharField(max_length=255)),
                ('request_response', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='Payment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('merchant_request_id', models.CharField(max_length=255)),
                ('checkout_request_id', models.CharField(max_length=255)),
                ('response_code', models.CharField(max_length=255)),
                ('response_description', models.CharField(max_length=255)),
                ('customer_message', models.CharField(max_length=255)),
                ('amount', models.IntegerField()),
                ('phone_number', models.CharField(max_length=255)),
                ('account_reference', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='PaypalDeposit',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('invoice', models.UUIDField(unique=True)),
                ('amount', models.DecimalField(decimal_places=2, max_digits=10)),
                ('member', models.CharField(max_length=200)),
                ('status', models.CharField(choices=[('Pending', 'Pending'), ('Completed', 'Completed'), ('Failed', 'Failed')], max_length=20)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='PaypalPayout',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('payout_id', models.CharField(max_length=255)),
                ('status', models.CharField(max_length=255)),
                ('receiver', models.CharField(max_length=255)),
                ('currency_sent', models.CharField(max_length=255)),
                ('amount_sent', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='ChamaMember',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('id_number', models.CharField(max_length=255)),
                ('phone', models.CharField(max_length=255)),
                ('address', models.CharField(max_length=255)),
                ('position', models.CharField(max_length=255)),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='members', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ChamaOfficial',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('id_number', models.CharField(max_length=255)),
                ('phone', models.CharField(max_length=255)),
                ('address', models.CharField(max_length=255)),
                ('position', models.CharField(max_length=255)),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='officials', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ChamaSigningMandate',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=255)),
                ('surname', models.CharField(max_length=255)),
                ('designation', models.CharField(max_length=255)),
                ('id_number', models.CharField(max_length=255)),
                ('mobile_no', models.CharField(max_length=255)),
                ('physical_address', models.CharField(max_length=255)),
                ('postal_address', models.CharField(max_length=255)),
                ('postal_code', models.CharField(max_length=255)),
                ('town', models.CharField(max_length=255)),
                ('email', models.CharField(max_length=255)),
                ('signature', models.FileField(blank=True, null=True, upload_to='chama_signatures/')),
                ('passport_photo', models.FileField(blank=True, null=True, upload_to='chama_passport_photo/')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('updated_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='chama_signature_mandate', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='CorporateDocuments',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reg_certificate', models.FileField(blank=True, null=True, upload_to='corp_files/')),
                ('cr_12', models.FileField(blank=True, null=True, upload_to='corp_files/')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='corp_files', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='BoardResolution',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file', models.FileField(blank=True, null=True, upload_to='board_resolutions/')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('document', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='board_resolutions', to='api.corporatedocuments')),
            ],
        ),
        migrations.CreateModel(
            name='DependantClaim',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('member_Number', models.CharField(max_length=100)),
                ('member_name', models.CharField(max_length=255)),
                ('PM_relation', models.CharField(max_length=100)),
                ('deceased_PM_relation', models.CharField(max_length=100)),
                ('memberID', models.CharField(max_length=100)),
                ('ID_file', models.FileField(upload_to='DependantClaim/id_files/')),
                ('employer', models.CharField(max_length=255)),
                ('DateofBirth', models.DateField()),
                ('dependantName', models.CharField(max_length=255)),
                ('dependantID', models.CharField(max_length=100)),
                ('collegeName', models.CharField(max_length=100)),
                ('collegeAdmissionLetter', models.FileField(upload_to='DependantClaim/college_admission_letters/')),
                ('DeceasedDateofBirth', models.DateField()),
                ('DeceasedDateofDeath', models.DateField()),
                ('deathCertificate', models.CharField(max_length=255)),
                ('deathCertificate_file', models.FileField(upload_to='DependantClaim/death_certificates/')),
                ('birthCertificate', models.CharField(blank=True, max_length=255, null=True)),
                ('birthCertificate_file', models.FileField(blank=True, null=True, upload_to='DependantClaim/birth_certificates/')),
                ('claimant_Name', models.CharField(blank=True, max_length=50, null=True)),
                ('claimant_Mobile_No', models.CharField(blank=True, max_length=50, null=True)),
                ('claimant_ID', models.CharField(blank=True, max_length=50, null=True)),
                ('claimant_ID_file', models.FileField(blank=True, null=True, upload_to='DependantClaim/claimant_ID_file/')),
                ('paymentAccountType', models.CharField(blank=True, max_length=80, null=True)),
                ('bank_name', models.CharField(blank=True, max_length=255, null=True)),
                ('bank_branch', models.CharField(blank=True, max_length=255, null=True)),
                ('account_name', models.CharField(blank=True, max_length=255, null=True)),
                ('account_number', models.CharField(blank=True, max_length=50, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('status', models.CharField(blank=True, max_length=50, null=True)),
                ('note', models.CharField(blank=True, max_length=100, null=True)),
                ('sacco_user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='dependant_claims', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='IndividualDocuments',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('kra_pin_doc', models.FileField(blank=True, null=True, upload_to='individual_files/')),
                ('birth_cert_doc', models.FileField(blank=True, null=True, upload_to='individual_files/')),
                ('national_id', models.FileField(blank=True, null=True, upload_to='individual_files/')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='individual_files', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='InpatientClaim',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('member_name', models.CharField(max_length=255)),
                ('memberID', models.CharField(max_length=100)),
                ('employer', models.CharField(max_length=255)),
                ('member_Number', models.CharField(max_length=100)),
                ('employer_branch', models.CharField(max_length=255)),
                ('ID_file', models.FileField(blank=True, null=True, upload_to='InpatientClaim/id_files/')),
                ('employer_tel', models.CharField(max_length=255)),
                ('dateOfAdmission', models.DateField()),
                ('dateOfDischarge', models.DateField()),
                ('hospitalNameAddress', models.CharField(max_length=255)),
                ('memberSignatureFile', models.FileField(upload_to='InpatientClaim/member_signatures/')),
                ('memberAgentSocietyMemberNumber', models.CharField(max_length=255)),
                ('applicationDate', models.DateField()),
                ('witnessSignatureFile', models.FileField(upload_to='InpatientClaim/witness_signatures/')),
                ('witnessSocietyMemberNumber', models.CharField(max_length=255)),
                ('witnessName', models.CharField(max_length=255)),
                ('witnessAddress', models.CharField(max_length=255)),
                ('doctorsComment', models.CharField(max_length=255)),
                ('doctorRubberStampFile', models.FileField(upload_to='InpatientClaim/doctors_rubber_stamps/')),
                ('doctorSignatureFile', models.FileField(upload_to='InpatientClaim/doctors_signatures/')),
                ('doctorSigningDate', models.DateField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('status', models.CharField(blank=True, max_length=50, null=True)),
                ('note', models.CharField(blank=True, max_length=100, null=True)),
                ('sacco_user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='inpatient_claims', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='KraPin',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('photo', models.FileField(blank=True, null=True, upload_to='kra_photos/')),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('document', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='kra_photos', to='api.corporatedocuments')),
            ],
        ),
        migrations.CreateModel(
            name='LoanApplication',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('product_id', models.CharField(max_length=255)),
                ('amount', models.DecimalField(decimal_places=2, max_digits=15)),
                ('repayment_installments', models.IntegerField(blank=True, null=True)),
                ('repayment_period', models.IntegerField(blank=True, null=True)),
                ('repayment_period_unit', models.CharField(blank=True, max_length=50, null=True)),
                ('anticipated_disbursement_date', models.CharField(blank=True, max_length=255, null=True)),
                ('first_repayment_date', models.CharField(blank=True, max_length=255, null=True)),
                ('disbursement_mode', models.CharField(blank=True, max_length=50, null=True)),
                ('repayment_mode', models.CharField(blank=True, max_length=100, null=True)),
                ('full_name', models.CharField(blank=True, max_length=255, null=True)),
                ('idNumber', models.CharField(blank=True, max_length=100, null=True)),
                ('dateOfBirth', models.CharField(blank=True, max_length=255, null=True)),
                ('gender', models.CharField(blank=True, max_length=10, null=True)),
                ('physical_address', models.CharField(blank=True, max_length=255, null=True)),
                ('postal_address', models.CharField(blank=True, max_length=255, null=True)),
                ('marital_status', models.CharField(blank=True, max_length=20, null=True)),
                ('email', models.CharField(blank=True, max_length=255, null=True)),
                ('phone', models.CharField(blank=True, max_length=20, null=True)),
                ('telephone', models.CharField(blank=True, max_length=20, null=True)),
                ('kra_pin', models.CharField(blank=True, max_length=100, null=True)),
                ('employment_status', models.CharField(blank=True, max_length=100, null=True)),
                ('employer', models.CharField(blank=True, max_length=255, null=True)),
                ('staff_id', models.CharField(blank=True, max_length=100, null=True)),
                ('work_email', models.EmailField(blank=True, max_length=254, null=True)),
                ('work_postal_address', models.CharField(blank=True, max_length=255, null=True)),
                ('position', models.CharField(blank=True, max_length=255, null=True)),
                ('terms_of_service', models.CharField(blank=True, max_length=20, null=True)),
                ('dateOfEmployement', models.CharField(blank=True, max_length=20, null=True)),
                ('business', models.CharField(blank=True, max_length=255, null=True)),
                ('business_email', models.CharField(blank=True, max_length=255, null=True)),
                ('business_address', models.CharField(blank=True, max_length=255, null=True)),
                ('business_location', models.CharField(blank=True, max_length=255, null=True)),
                ('business_activity', models.CharField(blank=True, max_length=255, null=True)),
                ('business_ownership', models.CharField(blank=True, max_length=50, null=True)),
                ('loan_purpose', models.CharField(blank=True, max_length=50, null=True)),
                ('sacco_loan_to_be_cleared', models.CharField(blank=True, max_length=50, null=True)),
                ('processing_fee', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('processing_fee_reference', models.CharField(blank=True, max_length=20, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('status', models.CharField(choices=[('PendingAppraisal', 'Pending Appraisal'), ('Appraised', 'Appraised')], default='PendingAppraisal', max_length=255)),
                ('account_holder_id', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='loan_application', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'unique_together': {('account_holder_id', 'product_id')},
            },
        ),
        migrations.CreateModel(
            name='Guarantor',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('guarantor_member_id', models.CharField(blank=True, max_length=40, null=True)),
                ('guarantor_type', models.CharField(blank=True, max_length=10, null=True)),
                ('guarantor_name', models.CharField(max_length=100)),
                ('guarantor_phone', models.CharField(max_length=20)),
                ('sender_name', models.CharField(blank=True, max_length=255, null=True)),
                ('approved', models.BooleanField(default=False)),
                ('rejected', models.BooleanField(default=False)),
                ('confirming_id', models.CharField(blank=True, max_length=255, null=True)),
                ('product_name', models.CharField(blank=True, max_length=255, null=True)),
                ('rejection_comment', models.CharField(blank=True, max_length=255, null=True)),
                ('loan_application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='guarantors', to='api.loanapplication')),
            ],
        ),
        migrations.CreateModel(
            name='LoanOriginationDocuments',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('payslip', models.FileField(blank=True, null=True, upload_to='documents/payslips/')),
                ('bank_statements', models.FileField(blank=True, null=True, upload_to='documents/bank_statements/')),
                ('mpesa_statements', models.FileField(blank=True, null=True, upload_to='documents/mpesa_statements/')),
                ('utility_bill', models.FileField(blank=True, null=True, upload_to='documents/utility_bills/')),
                ('cash_flow_analysis', models.FileField(blank=True, null=True, upload_to='documents/cash_flow_analysis/')),
                ('loan_application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='LoanOriginationDocuments', to='api.loanapplication')),
            ],
        ),
        migrations.CreateModel(
            name='NextOfKin',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('percentage', models.CharField(max_length=255)),
                ('phone', models.CharField(blank=True, max_length=255, null=True)),
                ('relationship', models.CharField(max_length=100)),
                ('is_deleted', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='next_of_kin', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ParentClaim',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('member_Number', models.CharField(max_length=100)),
                ('member_name', models.CharField(max_length=255)),
                ('PM_relation', models.CharField(max_length=100)),
                ('deceased_PM_relation', models.CharField(max_length=100)),
                ('memberID', models.CharField(max_length=100)),
                ('ID_file', models.FileField(upload_to='ParentClaim/id_files/')),
                ('employer', models.CharField(max_length=255)),
                ('DateofBirth', models.DateField()),
                ('parent', models.CharField(max_length=255)),
                ('parent_name', models.CharField(max_length=255)),
                ('parent_ID', models.CharField(max_length=100)),
                ('parent_ID_file', models.FileField(upload_to='ParentClaim/parent_id_files/')),
                ('DeceasedDateofBirth', models.DateField()),
                ('DeceasedDateofDeath', models.DateField()),
                ('deathCertificate', models.CharField(max_length=255)),
                ('deathCertificate_file', models.FileField(upload_to='ParentClaim/death_certificates/')),
                ('principalBirthCert', models.CharField(max_length=255)),
                ('principalBirthCert_file', models.FileField(upload_to='ParentClaim/principal_birth_cert_files/')),
                ('claimant_Name', models.CharField(blank=True, max_length=50, null=True)),
                ('claimant_Mobile_No', models.CharField(blank=True, max_length=50, null=True)),
                ('claimant_ID', models.CharField(blank=True, max_length=50, null=True)),
                ('claimant_ID_file', models.FileField(blank=True, null=True, upload_to='ParentClaim/claimant_ID_file/')),
                ('paymentAccountType', models.CharField(blank=True, max_length=50, null=True)),
                ('bank_name', models.CharField(blank=True, max_length=255, null=True)),
                ('bank_branch', models.CharField(blank=True, max_length=255, null=True)),
                ('account_name', models.CharField(blank=True, max_length=255, null=True)),
                ('account_number', models.CharField(blank=True, max_length=50, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('status', models.CharField(blank=True, max_length=50, null=True)),
                ('note', models.CharField(blank=True, max_length=100, null=True)),
                ('sacco_user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='parent_claims', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ParentInLawClaim',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('member_Number', models.CharField(max_length=100)),
                ('member_name', models.CharField(max_length=255)),
                ('PM_relation', models.CharField(max_length=100)),
                ('deceased_PM_relation', models.CharField(max_length=100)),
                ('memberID', models.CharField(max_length=100)),
                ('ID_file', models.FileField(upload_to='ParentInLawClaim/id_files/')),
                ('employer', models.CharField(max_length=255)),
                ('DateofBirth', models.DateField()),
                ('parent', models.CharField(max_length=255)),
                ('parent_in_law_name', models.CharField(max_length=255)),
                ('parent_in_law_ID', models.CharField(max_length=100)),
                ('parent_in_law_ID_file', models.FileField(upload_to='ParentInLawClaim/parent_in_law_id_files/')),
                ('DeceasedDateofBirth', models.DateField()),
                ('DeceasedDateofDeath', models.DateField()),
                ('deathCertificate', models.CharField(max_length=255)),
                ('deathCertificate_file', models.FileField(upload_to='ParentInLawClaim/death_certificates/')),
                ('spouseBirthCert', models.CharField(max_length=255)),
                ('spouseBirthCert_file', models.FileField(upload_to='ParentInLawClaim/spouse_birth_certificates/')),
                ('marriageCertificate', models.CharField(max_length=255)),
                ('marriageCertificate_file', models.FileField(upload_to='ParentInLawClaim/marriage_certificates/')),
                ('claimant_Name', models.CharField(blank=True, max_length=50, null=True)),
                ('claimant_Mobile_No', models.CharField(blank=True, max_length=50, null=True)),
                ('claimant_ID', models.CharField(blank=True, max_length=50, null=True)),
                ('claimant_ID_file', models.FileField(blank=True, null=True, upload_to='ParentInLawClaim/claimant_ID_file/')),
                ('paymentAccountType', models.CharField(blank=True, max_length=50, null=True)),
                ('bank_name', models.CharField(blank=True, max_length=255, null=True)),
                ('bank_branch', models.CharField(blank=True, max_length=255, null=True)),
                ('account_name', models.CharField(blank=True, max_length=255, null=True)),
                ('account_number', models.CharField(blank=True, max_length=50, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('status', models.CharField(blank=True, max_length=50, null=True)),
                ('note', models.CharField(blank=True, max_length=100, null=True)),
                ('sacco_user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='parent_in_law_claims', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='PassportPhoto',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('photo', models.FileField(blank=True, null=True, upload_to='passport_photos/')),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('document', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='passport_photos', to='api.corporatedocuments')),
            ],
        ),
        migrations.CreateModel(
            name='PrincipalClaim',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('member_Number', models.CharField(max_length=100)),
                ('member_name', models.CharField(max_length=255)),
                ('PM_relation', models.CharField(max_length=100)),
                ('deceased_PM_relation', models.CharField(max_length=100)),
                ('memberID', models.CharField(max_length=100)),
                ('ID_file', models.FileField(upload_to='PrincipalClaim/id_files/')),
                ('employer', models.CharField(max_length=255)),
                ('DateofBirth', models.DateField()),
                ('parent', models.CharField(max_length=255)),
                ('parent_name', models.CharField(max_length=100)),
                ('principalBirthCert', models.CharField(blank=True, max_length=100, null=True)),
                ('principalBirthCert_file', models.FileField(blank=True, null=True, upload_to='PrincipalClaim/principal_birth_cert_files/')),
                ('DeceasedDateofDeath', models.DateField()),
                ('deathCertificate', models.CharField(max_length=255)),
                ('deathCertificate_file', models.FileField(upload_to='PrincipalClaim/death_certificates/')),
                ('claimant_Name', models.CharField(blank=True, max_length=50, null=True)),
                ('claimant_Mobile_No', models.CharField(blank=True, max_length=50, null=True)),
                ('claimant_ID', models.CharField(blank=True, max_length=50, null=True)),
                ('claimant_ID_file', models.FileField(blank=True, null=True, upload_to='PrincipalClaim/claimant_ID_file/')),
                ('paymentAccountType', models.CharField(blank=True, max_length=50, null=True)),
                ('bank_name', models.CharField(blank=True, max_length=255, null=True)),
                ('bank_branch', models.CharField(blank=True, max_length=255, null=True)),
                ('account_name', models.CharField(blank=True, max_length=255, null=True)),
                ('account_number', models.CharField(blank=True, max_length=50, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('status', models.CharField(blank=True, max_length=50, null=True)),
                ('note', models.CharField(blank=True, max_length=100, null=True)),
                ('sacco_user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='principal_claims', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='SavingsAccount',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='savings_account', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Security',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('security_type', models.CharField(choices=[('Title Deed', 'Title Deed'), ('Cash Collateral', 'Cash Collateral'), ('NSE Shares', 'NSE Shares'), ('Other', 'Other')], max_length=50)),
                ('reference_number', models.CharField(blank=True, max_length=20, null=True)),
                ('description', models.TextField()),
                ('value', models.DecimalField(decimal_places=2, max_digits=15)),
                ('loan_application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='securities', to='api.loanapplication')),
            ],
        ),
        migrations.CreateModel(
            name='SigningMandate',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('id_no', models.CharField(blank=True, max_length=255, null=True)),
                ('signature', models.FileField(blank=True, null=True, upload_to='corp_signatures/')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='corp_signature', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='SpouseClaim',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('member_Number', models.CharField(max_length=100)),
                ('member_name', models.CharField(max_length=255)),
                ('PM_relation', models.CharField(max_length=100)),
                ('deceased_PM_relation', models.CharField(max_length=100)),
                ('memberID', models.CharField(max_length=100)),
                ('ID_file', models.FileField(upload_to='SpouseClaim/id_files/')),
                ('employer', models.CharField(max_length=255)),
                ('DateofBirth', models.DateField()),
                ('spouse_name', models.CharField(max_length=255)),
                ('spouse_ID', models.CharField(max_length=100)),
                ('spouse_ID_file', models.FileField(upload_to='SpouseClaim/spouse_id_files/')),
                ('DeceasedDateofBirth', models.DateField()),
                ('DeceasedDateofDeath', models.DateField()),
                ('deathCertificate', models.CharField(max_length=255)),
                ('deathCertificate_file', models.FileField(upload_to='SpouseClaim/death_certificates/')),
                ('marriageCertificate', models.CharField(max_length=255)),
                ('marriageCertificate_file', models.FileField(upload_to='SpouseClaim/marriage_certificates/')),
                ('claimant_Name', models.CharField(blank=True, max_length=50, null=True)),
                ('claimant_Mobile_No', models.CharField(blank=True, max_length=50, null=True)),
                ('claimant_ID', models.CharField(blank=True, max_length=50, null=True)),
                ('claimant_ID_file', models.FileField(blank=True, null=True, upload_to='SpouseClaim/claimant_ID_file/')),
                ('paymentAccountType', models.CharField(blank=True, max_length=50, null=True)),
                ('bank_name', models.CharField(blank=True, max_length=255, null=True)),
                ('bank_branch', models.CharField(blank=True, max_length=255, null=True)),
                ('account_name', models.CharField(blank=True, max_length=255, null=True)),
                ('account_number', models.CharField(blank=True, max_length=50, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('status', models.CharField(blank=True, max_length=50, null=True)),
                ('note', models.CharField(blank=True, max_length=100, null=True)),
                ('sacco_user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='spouse_claims', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='UserActivityLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('activity', models.CharField(blank=True, max_length=255, null=True)),
                ('api_endpoint', models.CharField(blank=True, max_length=255, null=True)),
                ('timestamp', models.DateTimeField(default=django.utils.timezone.now)),
                ('is_archived', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='SavingsApplication',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('product_id', models.CharField(max_length=10)),
                ('name', models.CharField(max_length=50)),
                ('product_name', models.CharField(blank=True, max_length=50, null=True)),
                ('term', models.CharField(blank=True, max_length=50, null=True)),
                ('monthly_remittance_amount', models.DecimalField(decimal_places=2, max_digits=10)),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('account_holder_id', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='savings_application', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'unique_together': {('account_holder_id', 'product_id')},
            },
        ),
    ]
