from django.contrib.auth.hashers import make_password

def encrypt_password(password, salt=None, hasher='pbkdf2_sha256'):
    """
    Encrypts a password using Django's PBKDF2 hashing.

    Args:
        password (str): The plaintext password to encrypt.
        salt (str): An optional salt to use. If not provided, Django generates one automatically.
        hasher (str): The hashing algorithm to use (default: pbkdf2_sha256).

    Returns:
        str: The encrypted password in Django's format.
    """
    encrypted_password = make_password(password, salt, hasher)
    return encrypted_password

# # Example usage
if __name__ == "__main__":
    plaintext_password = "12Kagb@#"
    encrypted = encrypt_password(plaintext_password)
    # print(f"Encrypted Password: {encrypted}")