from rest_framework import serializers
from rest_framework.response import Response
from . import models
# from django.core.mail import send_mail
# import vonage

class MemberSerializer(serializers.ModelSerializer):
    class Meta:
        model = models.CustomUser
        fields = '__all__'

class LoanApplicationSerializer(serializers.ModelSerializer):
    class Meta:
        model = models.LoanApplication
        fields = '__all__'

    def validate(self, attrs):
        # Conditionally validate `repayment_installments` and `repayment_period`
        if attrs.get('status') == models.LoanApplication.Status.Appraised:
            if not attrs.get('repayment_installments'):
                raise serializers.ValidationError({"repayment_installments": "This field is mandatory."})
            if not attrs.get('repayment_period'):
                raise serializers.ValidationError({"repayment_period": "This field is mandatory."})
        return attrs

class SavingsApplicationSerializer(serializers.ModelSerializer):
    class Meta:
        model = models.SavingsApplication
        fields = '__all__'

class UserActivityLogSerializer(serializers.ModelSerializer):
    user = MemberSerializer()

    class Meta:
        model = models.UserActivityLog
        fields = ['user', 'activity', 'api_endpoint', 'timestamp']

class SMSLogSerializer(serializers.ModelSerializer):
    class Meta:
        model = models.SMSLog
        fields  = ["phone", "message", "department", "response_status", 'timestamp']

class SpouseClaimSerializer(serializers.ModelSerializer):
    class Meta:
        model = models.SpouseClaim
        fields = '__all__'
        extra_kwargs = {
            'sacco_user': {'read_only': True},  # Ensure this field is not required from the frontend
        }

class PrincipalClaimSerializer(serializers.ModelSerializer):
    class Meta:
        model = models.PrincipalClaim
        fields = '__all__'
        extra_kwargs = {
            'sacco_user': {'read_only': True},  # Ensure this field is not required from the frontend
        }

class ParentClaimSerializer(serializers.ModelSerializer):
    class Meta:
        model = models.ParentClaim
        fields = '__all__'
        extra_kwargs = {
            'sacco_user': {'read_only': True},  # Ensure this field is not required from the frontend
        }

class ParentInLawClaimSerializer(serializers.ModelSerializer):
    class Meta:
        model = models.ParentInLawClaim
        fields = '__all__'
        extra_kwargs = {
            'sacco_user': {'read_only': True},  # Ensure this field is not required from the frontend
        }

class DependantClaimSerializer(serializers.ModelSerializer):
    class Meta:
        model = models.DependantClaim
        fields = '__all__'
        extra_kwargs = {
            'sacco_user': {'read_only': True},  # Ensure this field is not required from the frontend
        }

class InpatientClaimSerializer(serializers.ModelSerializer):
    class Meta:
        model = models.InpatientClaim
        fields = '__all__'
        extra_kwargs = {
            'sacco_user': {'read_only': True},  # Ensure this field is not required from the frontend
        }