from django.urls import path
from . import views
from django.conf import settings
from django.conf.urls.static import static
from rest_framework_simplejwt.views import TokenRefreshView
# from rest_framework_simplejwt.views import (
#     TokenObtainPairView,
#     TokenRefreshView,
# )

urlpatterns = [

    path('deactivate/<str:admin_sacco_user_id>/', views.DeactivateUserAccount.as_view(), name='deactivate-account'),

    # Token refresh
    path('token/refresh/', TokenRefreshView.as_view(), name='token_refresh'),
    path('get-csrf-token/', views.get_csrf_token, name='get_csrf_token'),

    # main urls
    path('send-otp/', views.SendOtpView.as_view(), name='send-otp'),
    path('verify-otp/', views.VerifyOtpView.as_view(), name='verify-otp'),
    path('reset-password/', views.ResetPasswordView.as_view(), name='reset-password'),
    path('check-email/', views.check_email_exists, name='check_email_exists'),
    path('check-number/', views.check_phone_exists, name='check_phone_exists'),
    path('check-business-name/', views.check_business_exists, name='check_business_exists'),
    path('check-chama-name/', views.check_chama_exists, name='check_chama_exists'),
    path('register/', views.create_member),
    # path('get_id_access_token/', views.get_id_access_token),
    path('corp-register/', views.create_corp_member),
    path('chama-register/', views.create_chama_member),
    path('login/', views.login_view),
    path('verify-session/', views.verify_session, name="verify-session"),
    path('health-check/', views.health_check, name="health-check"),
    path('login-verify-otp/<str:sacco_user_id>/', views.login_verify_otp, name='login_verify_otp'),
    path('logout/<str:sacco_user_id>/', views.LogoutView, name='logout'),
    path('deactivate/<str:sacco_user_id>/', views.DeactivateView.as_view(), name='deactivate'),
    path('verify-member/<str:sacco_user_id>/', views.verify_member_via_otp, name='verify_member_via_otp'),
    path('save-referral/', views.save_referral, name='save_referral'),
    path('change-password/', views.change_password, name='change_password'),
    path('profile-picture/<str:sacco_user_id>/', views.get_profile_picture, name='get_profile_picture'),
    path('signature/<str:sacco_user_id>/', views.get_signature, name='get_signature'),
    path("update_user_profile/<str:member_id>/", views.update_user_profile , name="update_profile"),
    path("update_chama_user_profile/<str:member_id>/", views.update_chama_user_profile , name="update_chama_user_profile"),
    path("update_chama_signatories/<str:member_id>/", views.update_chama_signatories , name="update_chama_signatories"),
    path("update_user_images/<str:member_id>/", views.update_user_images, name="update_user_images"),
    path("update_user_next_of_kin/<str:member_id>/", views.update_user_next_of_kin, name="update_user_next_of_kin"),
    # path('contact-us/', views.contact_us, name='contact_us'),
    path('id-validation/', views.validate_ID, name='validate_ID'),
    path('signature-id-validation/', views.signature_validate_ID, name='signature_validate_ID'),

    # member urls
    path('show_member_for_dashboard/<str:member_id>/', views.show_member_for_dashboard),
    path('member-details/<str:member_id>/', views.member_details, name='get_member_details'),
    path('memberr-details/<str:member_id>/', views.memberr_details, name='get_memberr_details'),
    path('member-name/<str:member_ID>/', views.get_member_name, name='get_member_name'),
    path('corp-member-details/<str:member_id>/', views.corp_member_details, name='get_corp_member_details'),
    path('chama-member-details/<str:member_id>/', views.chama_member_details),
    path('list_onboarded_members', views.list_onboarded_members),
    path('list_accounts_created', views.list_accounts_created),
    path('list_loan_accounts_created', views.list_loan_accounts_created),
    path('show_pending_members', views.show_pending_members),
    path('show_active_members', views.show_active_members),
    path('show_all_members', views.show_all_members),
    path('show_all_internet_banking_members', views.show_all_internet_banking_members),
    path('show_all_members_fosa_accounts', views.show_all_members_fosa_accounts),

    path('show_onboarded_member/<str:member_id>/', views.show_onboarded_member),
    path('show_onboarded_member_next_of_kin/<str:member_id>/', views.show_onboarded_member_next_of_kin),
    path('show_onboarded_corporate_member/<str:member_id>/', views.show_onboarded_corporate_member),
    path('show_onboarded_chama_member/<str:member_id>/', views.show_onboarded_chama_member),
    path('show_member/<str:member_id>/', views.show_member),
    path('check-eligibility/<str:member_id>/', views.check_loan_eligibility),
    path('check-m-loan-eligibility/<str:member_id>/', views.check_m_loan_eligibility),
    path('m-loan-application/<str:member_id>/', views.create_m_loan_application),
    path('show_member_savings_and_loans/<str:member_id>/', views.show_member_savings_and_loans, name='show_member_savings_and_loans'),
    # path('member_savings/<str:member_id>/', views.member_savings, name='member_savings'),
    # path('member_loans/<str:member_id>/', views.member_loans, name='member_loans'),


    

    # savings urls
    path('show_member_savings/<str:member_id>', views.show_member_savings),
    path('show_member_active_savings/<str:member_id>', views.show_member_active_savings),
    path('show_member_pending_approval_savings/<str:member_id>', views.show_member_pending_approval_savings),
    path('show_member_dormant_savings/<str:member_id>', views.show_member_dormant_savings),
    # path("savings_product/<str:savings_id>", views.show_saving_product ),
    path("show_savings/<str:savings_id>", views.show_savings),
    path("savings_deposit/", views.savings_deposit),
    # path("saving_withdrawal/", views.savings_withdrawal),
    path("savings_transfer/<str:member_id>", views.savings_transfer),
    path('savings-application/<str:member_id>', views.create_savings_application, name='create_savings_application'),
    path('barizi-savings-application/<str:member_id>', views.create_barizi_savings, name='create_barizi_savings'),
    path('savings-detail/<str:member_id>/<str:savings_id>', views.show_savings_details, name='show_savings_details'),
    path('show_saving_transactions/<str:savings_id>', views.show_saving_transactions),
    
    
    # loan urls
    path('check-loan/<str:member_id>/<str:productName>', views.check_existing_loan_product),
    path('show_member_loans/<str:member_id>', views.show_member_loans),
    path('show_memberr_loans/<str:member_id>', views.show_memberr_loans),
    path('show_guarantor_requests/<str:member_id>/', views.show_guarantor_requests),
    path("show_my_loan_guarantor_requests/<str:member_id>/", views.show_my_loan_guarantor_requests),
    path("change_guarantee_status/<str:guarantee_id>/", views.change_guarantee_status),
    path("reject_guarantee_status/<str:guarantee_id>/", views.reject_guarantee_status),
    path("list_loan_details_to_update_securities/<str:sacco_member_id>/<str:loan_id>/", views.list_loan_details_to_update_securities, name='list_loan_details_to_update_securities'),
    path("update_loan_securities/<str:sacco_member_id>/<str:loan_id>/", views.update_loan_securities, name='update_loan_securities'),
    path('show_member_loan_repayment/<str:member_id>', views.show_member_loan_repayment),
    path('show_member_arrears_loans/<str:member_id>', views.show_member_arrears_loans),
    # path('show_member_closed_loan/<str:member_id>', views.show_member_closed_loan),
    path('show_member_approved_loan/<str:member_id>', views.show_member_approved_loan),
    path('show_member_loan_pending_approval/<str:member_id>', views.show_member_loan_pending_approval),
    path('show_member_loan_partial_application/<str:member_id>', views.show_member_loan_partial_application),
    path('show_loan_transactions/<str:loan_id>', views.show_loan_transactions),
    path('loan-details/<str:member_id>/<str:loan_id>', views.show_loan_details, name='show_loan_details'),
    path('loan-schedule/<str:member_id>/<str:loan_id>/', views.show_loan_schedule, name='loan-schedule'),
    path('loan-application/<str:member_id>', views.create_loan_application, name='create_loan_application'),
    path("approve-loan-application/<str:member_id>/<str:loan_id>/", views.approve_and_update_loan_application),
    path("reject-loan-application/<str:member_id>/<str:loan_id>/", views.reject_loan_application),
    path("list_loan_applications", views.list_loan_applications),
    path("list_loan_applications_for_download/<str:sacco_member_id>/", views.list_loan_applications_for_download, name='list_loan_applications_for_download'),
    path("view_loan_application/<str:loan_id>/", views.view_loan_application),
    path('loan_eligibility_by_products/<str:member_id>', views.loan_eligibility_by_products),
    path("loan_repayment/<str:member_id>", views.loan_repayment),


    # statements urls
    path("list_member_loans_for_dashboard/<str:member_id>/", views.list_member_loans_for_dashboard),
    path('account_statements/<str:member_id>', views.account_statements),
    path('list_member_savings/<str:member_id>/', views.list_member_savings),
    path("savings_transactions_by_user/<str:saving_id>/<str:member_id>/", views.saving_transactions_by_id),
    path("savings_transactions/<str:saving_id>/<str:member_id>/", views.savings_transactions_by_admin),
    path('loan_statements/<str:member_id>', views.loan_statements),
    path("list_member_loans/<str:member_id>/", views.list_member_loans),
    path("loan_transactions_by_user/<str:loan_id>/<str:member_id>/", views.loan_transactions_by_id),
    path("loan_transactions/<str:loan_id>/<str:member_id>/", views.loan_transactions_by_admin),
    path('list_all_payment_requests', views.list_all_payment_requests, name='payment_requests'),
    path('list_all_internet_banking_transactions', views.list_all_internet_banking_transactions, name='list_all_internet_banking_transactions'),
    path('withdrawals_above_100000', views.withdrawals_above_100000, name='withdrawals-above-100000'),
    path('stats_for_supervisor_dashboard/<str:sacco_user_id>/', views.stats_for_supervisor_dashboard, name='stats-for-supervisor-dashboard'),

    # Risk Claim Urls
    path('spouse-claim/', views.SpouseClaimView.as_view(), name='spouse-claim'),
    path('dependant-claim/', views.DependantClaimView.as_view(), name='dependant-claim'),
    path('parentInLaw-claim/', views.ParentInLawClaimView.as_view(), name='parentInLaw-claim'),
    path('parent-claim/', views.ParentClaimView.as_view(), name='parent-claim'),
    path('principal-claim/', views.PrincipalClaimView.as_view(), name='principal-claim'),
    path('inpatient-claim/', views.InpatientClaimView.as_view(), name='inpatient-claim'),
    # Risk Claim View Urls
    path('list-risk-claims/', views.RiskClaimListView.as_view(), name='list-risk-claims'),
    path('spouse-risk-claim-detail/<int:risk_id>/', views.SpouseRiskClaimDetailView.as_view(), name='spouse-risk-claim-detail'),
    path('principal-risk-claim-detail/<int:risk_id>/', views.PrincipalRiskClaimDetailView.as_view(), name='principal-risk-claim-detail'),
    path('parent-risk-claim-detail/<int:risk_id>/', views.ParentRiskClaimDetailView.as_view(), name='parent-risk-claim-detail'),
    path('parentInLaw-risk-claim-detail/<int:risk_id>/', views.ParentInLawRiskClaimDetailView.as_view(), name='parentInLaw-risk-claim-detail'),
    path('dependant-risk-claim-detail/<int:risk_id>/', views.DependantRiskClaimDetailView.as_view(), name='dependant-risk-claim-detail'),
    path('inpatient-risk-claim-detail/<int:risk_id>/', views.InpatientRiskClaimDetailView.as_view(), name='inpatient-risk-claim-detail'),
    
    # Approve / Reject Risk Claim
    path("update-risk-claim/<str:claim_id>/<str:member_id>/", views.update_risk_claim),
    path('fetch-risk/<str:member_number>/', views.fetch_risk),
    path('fetch-In-patient-risk/<str:member_number>/', views.fetch_In_patient_risk),

    # Refresh Member Status and FOSA
    path("refresh_members_status_fosa/", views.refresh_members_status_fosa),
    path("refresh_members_fosa_accounts/", views.refresh_members_fosa_accounts),

    # Payment Endpoints
    path("checkout_paypal", views.checkout_paypal), #open page to send to paypal checkout
    path("success", views.payment_successfull, name="paypal-payment-success"),
    path("failed", views.payment_failed, name="paypal-payment-fail"),
    path("swift_payment", views.swift_payment),
    path("payout_paypal", views.payout_paypal), # pay to customer
    path("get_paypal_access_token", views.get_paypal_access_token),
    path("check_paypal_payout_status/<str:payout_id>/", views.check_paypal_payout_status),
    path("checkout_paypal_restsdk", views.checkout_paypal_restsdk),
    # path("pay_customer_mpesa", views.pay_customer_mpesa ),
    path("pay_customer_mpesa/<str:sacco_member_id>/", views.pay_customer_mpesa),
    path("pay_bill", views.pay_bill), 
    path("customer_pay_bill", views.customer_pay_bill),
    path('customer_pay_joining_fee', views.customer_pay_joining_fee),
    path('customer_deposit_to_fosa/', views.customer_deposit_to_fosa),
    path('stk_push_query_payment/<str:checkout_id>/', views.stk_push_query_payment),
    path('get_mpesa_reference/<str:checkout_id>/', views.get_mpesa_reference, name='get_mpesa_reference'),
    path('payment_callback_mpesa', views.mpesa_callback, name='mpesa_callback'),
    path('payment_b2c_result', views.mpesa_b2c_callback, name='mpesa_b2c_callback'),
    # path("return_fosa_balance", views.return_fosa_balance),
    # path("mambu_client", views.mambu_client),
    path("deposit_to_fosa/<str:sacco_member_id>/<int:amount>/", views.deposit_to_fosa),
    # path("withdrawal", views.withdrawal),

    # Admin Endpoints
    path("log-user-activity", views.log_user_activity),
    path("get-user-logs", views.get_user_logs),
    path("get-archived-logs", views.get_archived_logs),
    path("archive-logs", views.archive_logs),
    # path("delete-log/<str:log_id>", views.delete_log),
    
    # SMS Endpoints
    path("get-sms-logs", views.get_sms_logs),
    path("get-archived-sms-logs", views.get_archived_sms_logs),
    path("archive-sms-logs", views.archive_sms_logs),
    # path("delete-sms-log/<str:log_id>", views.delete_sms_log),

    # Guarantor sms url
    path("sms_callback_advanta", views.sms_callback_advanta),


    # test urls
    path('create-member/', views.registers),
    # path('change_member_state/<str:member_id>', views.change_member_state),
    # path('verify_individual/', views.verify_individual),
    # path('extract_members', views.extract_members),
    path('extract_member/<str:member_id>/', views.extract_single_member),
    path('extract_kwara_members_excel', views.extract_kwara_members_excel),
    # path('lipanampesa', views.token_na_mpesa),
    path('mpesa', views.lipa_na_mpesa),
    # path('check_account', views.check_account),
    # path("test-loan_repayment/", views.test_loan_repayment),
    # path('get_access_token/', views.get_access_token),
    # path('token/', TokenObtainPairView.as_view(), name='token_obtain_pair'),
    # path('token/refresh/', TokenRefreshView.as_view(), name='token_refresh'),    
]
if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)